<?php

namespace App\Http\Controllers;

use App\Gst;
use Illuminate\Http\Request;

class GstController extends Controller
{
    public function index()
    {
        $data = Gst::first();
        return view('admin.gst.setting',compact('data'));
    }
    public function update(Request $request)
    {
        // Get the first record or create a new instance (does NOT insert yet)
        $gst = Gst::firstOrNew(); // Ensures a single instance to update
    
        // Set the fields
        $gst->gst_enable   = $request->gst_enable;
        $gst->gst_number   = $request->gst_number;
        $gst->company_name = $request->company_name;
        $gst->address      = $request->address;
        $gst->gst_per      = $request->gst_per;
    
        // Save the record (either updates or inserts depending on if it existed)
        $gst->save();
    
        return back()->with('success', 'GST Setting Updated Successfully');
    }
}
